<?php
use App\Models\Investment;
use App\Models\InvestmentPackage;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Mail\DepositRequestRejectedMail;
use App\Mail\WalletTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\Investment\SubscriptionService;
use App\Services\Sms\SmsNotifier;
use App\Services\Vrm\InvestmentEmailService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Subscriptions') }}</x-slot>
        <x-slot name="desc">{{ __('Approve or reject package subscription requests and review subscription records.') }}</x-slot>

        {!! $this->renderNotification() !!}

        <div class="mb-4">
            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Request Status Filter') }}</label>
            <select wire:model.live="status"
                class="mt-1 block w-full max-w-xs rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                <option value="pending">{{ __('Pending') }}</option>
                <option value="approved">{{ __('Approved') }}</option>
                <option value="rejected">{{ __('Rejected') }}</option>
                <option value="all">{{ __('All') }}</option>
            </select>
        </div>

        <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100 mb-2">{{ __('Subscription Requests') }}</h3>
        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Member') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Package') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Amount') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                        <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Actions') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    @forelse ($this->subscriptionRequests as $request)
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ $request->user?->name ?? '-' }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ data_get($request->meta, 'package_id') ?? '-' }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ app(\App\Services\DefaultCurrencyService::class)->code() }} {{ number_format((float) (data_get($request->meta, 'amount') ?? $request->amount), 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ ucfirst($request->status) }}</td>
                            <td class="py-4 pr-4 pl-3 text-right">
                                @if ($request->status === 'pending')
                                    <button type="button" wire:click="$js.approveRequest({{ $request->id }})"
                                        class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500">{{ __('Approve') }}</button>
                                    <button type="button" wire:click="$js.rejectRequest({{ $request->id }})"
                                        class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500">{{ __('Reject') }}</button>
                                @else
                                    <span class="text-xs text-gray-500">{{ __('Processed') }}</span>
                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No subscription requests found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-4">{{ $this->subscriptionRequests->links() }}</div>

        <h3 class="text-base font-semibold text-gray-900 dark:text-gray-100 mt-8 mb-2">{{ __('Subscriptions') }}</h3>
        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg mt-2">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Member') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Package') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Principal') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Expected Return') }}</th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100">{{ __('Status') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    @forelse ($this->subscriptions as $subscription)
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100">{{ $subscription->user?->name ?? '-' }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ $subscription->package?->name ?? '-' }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ app(\App\Services\DefaultCurrencyService::class)->code() }} {{ number_format((float) $subscription->principal_amount, 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ app(\App\Services\DefaultCurrencyService::class)->code() }} {{ number_format((float) $subscription->expected_return_amount, 2) }}</td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100">{{ ucfirst($subscription->status) }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400">{{ __('No subscriptions found.') }}</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-4">{{ $this->subscriptions->links() }}</div>
    </x-admin-panel>

    @script
        <script>
            $js('approveRequest', async (requestId) => {
                const result = await Swal.fire({
                    title: 'Approve subscription request?',
                    icon: 'question',
                    showCancelButton: true,
                });

                if (result.isConfirmed) {
                    $wire.approve(requestId);
                }
            });

            $js('rejectRequest', async (requestId) => {
                const result = await Swal.fire({
                    title: 'Reject subscription request?',
                    icon: 'warning',
                    showCancelButton: true,
                });

                if (result.isConfirmed) {
                    $wire.reject(requestId);
                }
            });
        </script>
    @endscript
</div>