<?php
use App\Models\Vrm\Utility;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Manage Wallet Till') }}</x-slot>
        <x-slot name="desc">{{ __('Update the M-Pesa Till/Paybill number used for transactions.') }}</x-slot>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-8 mb-5 sm:px-6">
            {!! $this->renderNotification() !!}

            <form wire:submit="save">
                <div class="space-y-12">
                    <div class="grid grid-cols-1 gap-x-8 gap-y-10 pb-12 md:grid-cols-3">
                        <div>
                            <h2 class="text-base/7 font-semibold text-gray-900 dark:text-gray-100">{{ __('M-Pesa Till Details') }}</h2>
                            <p class="mt-1 text-sm/6 text-gray-600 dark:text-gray-300">
                                {{ __('This number will be displayed to members when they initiate a deposit. Ensure it is a valid M-Pesa Till or Paybill number.') }}
                            </p>
                        </div>

                        <div class="grid max-w-2xl grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6 md:col-span-2">
                            <div class="col-span-full">
                                <label for="walletTill" class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100">
                                    {{ __('Wallet Till Number') }}
                                </label>
                                <div class="mt-2">
                                    <div class="flex items-center rounded-md bg-white dark:bg-gray-700 pl-3 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-indigo-600">
                                        <div class="flex shrink-0 items-center justify-center pr-2">
                                            <i class="fa-solid fa-building-storefront text-gray-400 dark:text-gray-500"></i>
                                        </div>
                                        <input type="text" id="walletTill" wire:model="walletTill"
                                            class="block min-w-0 grow py-2.5 pr-3 pl-1 text-base text-gray-900 dark:text-gray-100 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-none sm:text-sm/6"
                                            placeholder="e.g. 123456">
                                    </div>
                                    @error('walletTill')
                                        <p class="mt-2 text-sm text-red-600 italic">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-span-full">
                                <div class="flex items-center justify-end gap-x-3 border-t border-gray-900/10 dark:border-gray-100/10 pt-6">
                                    <button type="submit" wire:loading.attr="disabled"
                                        class="inline-flex items-center gap-2 rounded-md bg-indigo-600 px-4 py-2.5 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500 transition-colors disabled:opacity-50">
                                        <span wire:loading.remove wire:target="save" class="flex items-center gap-2">
                                            <i class="fa-solid fa-floppy-disk"></i>
                                            {{ __('Save Changes') }}
                                        </span>
                                        <span wire:loading wire:target="save" class="flex items-center gap-2">
                                            <i class="fa-solid fa-spinner animate-spin"></i>
                                            {{ __('Saving...') }}
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </x-admin-panel>
</div>