<?php
use App\Concerns\PasswordValidationRules;
use App\Concerns\ProfileValidationRules;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Notifications\PasswordUpdatedNotification;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\Hash;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	@include('partials.trading.topbar', ['title' => 'ACCOUNT'])

	<div class="px-4 space-y-4">
		{!! $this->renderNotification() !!}

		<iframe src="https://live.mystocks.co.ke/ticker/tape$" height="30" width="100%" frameborder="0" scrolling="no"
			spellcheck="false"></iframe>

		<div class="flex flex-col items-center py-6">
			<div class="w-20 h-20 bg-secondary rounded-full flex items-center justify-center mb-3">
				<i class="fa-solid fa-user h-10 w-10 text-muted-foreground"></i>
			</div>
			<h2 class="text-foreground font-bold text-lg">{{ auth()->user()->name }}</h2>
			<p class="text-muted-foreground text-sm">{{ auth()->user()->email }}</p>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-2">
			<p class="text-sm text-muted-foreground">{{ __('Wallet') }}</p>
			<p class="text-xl font-bold text-foreground">{{ $this->wallet->currency_code }}
				{{ number_format((float) $this->wallet->balance, 2) }}</p>
			<p class="text-sm text-muted-foreground">{{ __('Available') }}: {{ $this->wallet->currency_code }}
				{{ number_format($this->wallet->available_balance, 2) }}</p>
			<p class="text-sm text-muted-foreground">{{ __('In Trade') }}: {{ $this->wallet->currency_code }}
				{{ number_format((float) $this->wallet->used_amount, 2) }}</p>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground">{{ __('Deposit Funds') }}</p>
			<div class="flex items-center gap-2">
				<input type="number" step="0.01" min="0.01" wire:model="depositAmount"
					class="flex-1 rounded-md border border-border px-3 py-2" placeholder="0.00" />
				<button type="button" wire:click="deposit"
					class="rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">{{ __('Deposit') }}</button>
			</div>
            <a href="{{ route('member.mpesa-deposit') }}" wire:navigate
                class="block text-center rounded-md border border-primary px-4 py-2 text-sm font-semibold text-primary">
                {{ __('Deposit via M-Pesa') }}
            </a>
		</div>

        <a href="{{ route('member.investments') }}" wire:navigate
            class="w-full bg-card rounded-xl p-4 border border-border flex items-center gap-4 text-left hover:border-primary/30 transition-colors">
            <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0">
                <i class="fa-solid fa-sack-dollar h-5 w-5 text-primary"></i>
            </div>
            <div class="flex-1 min-w-0">
                <p class="text-foreground font-semibold text-sm">{{ __('Investments') }}</p>
                <p class="text-muted-foreground text-xs">{{ __('Invest and claim fixed 2x returns after maturity') }}</p>
            </div>
            <i class="fa-solid fa-chevron-right h-5 w-5 text-muted-foreground shrink-0"></i>
        </a>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground">{{ __('Withdraw Funds') }}</p>
			<div class="flex items-center gap-2">
				<input type="number" step="0.01" min="0.01" wire:model="withdrawAmount"
					class="flex-1 rounded-md border border-border px-3 py-2" placeholder="0.00" />
				<button type="button" wire:click="withdraw"
					class="rounded-md bg-destructive px-4 py-2 text-sm font-semibold text-destructive-foreground">{{ __('Withdraw') }}</button>
			</div>
		</div>

		<div class="space-y-2">
			<p class="text-sm font-semibold text-foreground">{{ __('Recent Transactions') }}</p>
			@forelse ($this->transactions as $transaction)
				<div class="bg-card rounded-xl p-3 border border-border flex items-center justify-between">
					<div>
						<p class="text-sm font-semibold text-foreground">{{ ucfirst(str_replace('_', ' ', $transaction->type)) }}</p>
						<p class="text-xs text-muted-foreground">{{ $transaction->created_at?->format('Y-m-d H:i') }}</p>
					</div>
					<div class="text-right">
						<p class="text-sm font-semibold text-foreground">{{ $transaction->currency_code }}
							{{ number_format((float) $transaction->amount, 2) }}</p>
						<p class="text-xs text-muted-foreground">{{ ucfirst($transaction->status) }}</p>
					</div>
				</div>
			@empty
				<p class="text-sm text-muted-foreground">{{ __('No transactions yet.') }}</p>
			@endforelse
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground">{{ __('Personal Information') }}</p>
			<div>
				<label for="name" class="required block text-xs font-medium text-muted-foreground mb-1">{{ __('Name') }}</label>
				<input id="name" type="text" wire:model="name" class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				@error('name')
					<span class="text-red-500 text-xs">{{ $message }}</span>
				@enderror
			</div>
			<div>
				<label for="email" class="required block text-xs font-medium text-muted-foreground mb-1">{{ __('Email') }}</label>
				<input id="email" type="email" wire:model="email" class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				@error('email')
					<span class="text-red-500 text-xs">{{ $message }}</span>
				@enderror
			</div>
			<button type="button" wire:click="updateProfileInformation"
				class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
				{{ __('Save Profile') }}
			</button>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground">{{ __('Password & Security') }}</p>
			<div>
				<label for="current_password" class="required block text-xs font-medium text-muted-foreground mb-1">{{ __('Current Password') }}</label>
				<input id="current_password" type="password" wire:model="current_password"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				@error('current_password')
					<span class="text-red-500 text-xs">{{ $message }}</span>
				@enderror
			</div>
			<div>
				<label for="password" class="required block text-xs font-medium text-muted-foreground mb-1">{{ __('New Password') }}</label>
				<input id="password" type="password" wire:model="password"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				@error('password')
					<span class="text-red-500 text-xs">{{ $message }}</span>
				@enderror
			</div>
			<div>
				<label for="password_confirmation" class="required block text-xs font-medium text-muted-foreground mb-1">{{ __('Confirm New Password') }}</label>
				<input id="password_confirmation" type="password" wire:model="password_confirmation"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
			</div>
			<button type="button" wire:click="updatePassword"
				class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
				{{ __('Update Password') }}
			</button>
		</div>
	</div>
</div>