<?php
use App\Facades\Vrm\MediaForge;
use App\Models\Security;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;
?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Add Security') }}</x-slot>
        <x-slot name="desc">{{ __('Create a security mapping with logo, ticker name, and description.') }}</x-slot>
        <x-slot name="button">
            <a href="{{ route('admin.securities.index') }}"
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                {{ __('Go Back') }}
            </a>
        </x-slot>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-5 mb-5 sm:p-6">
            {!! $this->renderNotification() !!}

            <form wire:submit="save" class="space-y-6">
                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Ticker Name') }}</label>
                        <input type="text" wire:model="trading_name"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 uppercase dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm">{{ $errors->first('trading_name') }}</span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Logo') }}</label>
                        <input type="file" wire:model="logo" accept=".jpg,.jpeg,.png,.webp"
                            class="mt-1 block w-full cursor-pointer px-3 py-2 text-sm file:mr-4 file:rounded-md file:border-0 file:bg-gray-200 dark:file:bg-gray-600 file:px-3 file:py-1.5 file:text-sm file:font-semibold file:text-gray-900 dark:file:text-gray-100 hover:file:bg-gray-300 dark:hover:file:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2" />
                        <span class="text-red-500 text-sm">{{ $errors->first('logo') }}</span>
                        @if ($logo)
                            <img src="{{ $logo->temporaryUrl() }}" class="mt-2 h-16 w-16 rounded object-cover" alt="preview" />
                        @endif
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('Description') }}</label>
                    <textarea wire:model="description" rows="4"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"></textarea>
                    <span class="text-red-500 text-sm">{{ $errors->first('description') }}</span>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white hover:bg-indigo-500">
                        {{ __('Save Security') }}
                    </button>
                </div>
            </form>
        </div>
    </x-admin-panel>
</div>